/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.factories;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.components.BehaviourComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.EntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.LocationComponent;
import technology.rocketjump.undermount.entities.model.physical.PhysicalEntityComponent;
import technology.rocketjump.undermount.mapping.model.TiledMap;

@Singleton
public class FurnitureEntityFactory {
    private static final float MAX_POSITION_OFFSET = 0.05f;
    private static final float ITEM_RADIUS = 0.4f;
    private final MessageDispatcher messageDispatcher;
    private final EntityAssetUpdater entityAssetUpdater;

    @Inject
    public FurnitureEntityFactory(MessageDispatcher messageDispatcher, EntityAssetUpdater entityAssetUpdater) {
        this.messageDispatcher = messageDispatcher;
        this.entityAssetUpdater = entityAssetUpdater;
    }

    public Entity create(EntityAttributes attributes, GridPoint2 tilePosition, BehaviourComponent behaviour, TiledMap areaMap) {
        PhysicalEntityComponent physicalComponent = this.createPhysicalComponent(attributes);
        LocationComponent locationComponent = this.createLocationComponent(tilePosition);
        Entity entity = new Entity(EntityType.FURNITURE, physicalComponent, behaviour, locationComponent, this.messageDispatcher, areaMap);
        this.entityAssetUpdater.updateEntityAssets(entity);
        return entity;
    }

    private LocationComponent createLocationComponent(GridPoint2 tilePosition) {
        LocationComponent locationComponent = new LocationComponent();
        Vector2 worldPosition = new Vector2((float)tilePosition.x + 0.5f, (float)tilePosition.y + 0.5f);
        locationComponent.setWorldPosition(worldPosition, false);
        locationComponent.setFacing(EntityAssetOrientation.DOWN.toVector2().cpy());
        locationComponent.setRadius(0.4f);
        return locationComponent;
    }

    private PhysicalEntityComponent createPhysicalComponent(EntityAttributes attributes) {
        PhysicalEntityComponent physicalComponent = new PhysicalEntityComponent();
        physicalComponent.setAttributes(attributes);
        return physicalComponent;
    }
}

